/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.support.v4.widget.SearchViewCompatHoneycomb;
import android.support.v4.widget.SearchViewCompatIcs;
import android.view.View;

public final class SearchViewCompat {
    private static final SearchViewCompatImpl IMPL = Build.VERSION.SDK_INT >= 14 ? new SearchViewCompatIcsImpl() : (Build.VERSION.SDK_INT >= 11 ? new SearchViewCompatHoneycombImpl() : new SearchViewCompatStubImpl());

    private SearchViewCompat(Context context) {
    }

    public static View newSearchView(Context context) {
        return IMPL.newSearchView(context);
    }

    public static void setSearchableInfo(View searchView, ComponentName searchableComponent) {
        IMPL.setSearchableInfo(searchView, searchableComponent);
    }

    public static void setImeOptions(View searchView, int imeOptions) {
        IMPL.setImeOptions(searchView, imeOptions);
    }

    public static void setInputType(View searchView, int inputType) {
        IMPL.setInputType(searchView, inputType);
    }

    public static void setOnQueryTextListener(View searchView, OnQueryTextListener listener) {
        IMPL.setOnQueryTextListener(searchView, listener);
    }

    public static void setOnCloseListener(View searchView, OnCloseListener listener) {
        IMPL.setOnCloseListener(searchView, listener);
    }

    public static CharSequence getQuery(View searchView) {
        return IMPL.getQuery(searchView);
    }

    public static void setQuery(View searchView, CharSequence query, boolean submit) {
        IMPL.setQuery(searchView, query, submit);
    }

    public static void setQueryHint(View searchView, CharSequence hint) {
        IMPL.setQueryHint(searchView, hint);
    }

    public static void setIconified(View searchView, boolean iconify) {
        IMPL.setIconified(searchView, iconify);
    }

    public static boolean isIconified(View searchView) {
        return IMPL.isIconified(searchView);
    }

    public static void setSubmitButtonEnabled(View searchView, boolean enabled) {
        IMPL.setSubmitButtonEnabled(searchView, enabled);
    }

    public static boolean isSubmitButtonEnabled(View searchView) {
        return IMPL.isSubmitButtonEnabled(searchView);
    }

    public static void setQueryRefinementEnabled(View searchView, boolean enable) {
        IMPL.setQueryRefinementEnabled(searchView, enable);
    }

    public static boolean isQueryRefinementEnabled(View searchView) {
        return IMPL.isQueryRefinementEnabled(searchView);
    }

    public static void setMaxWidth(View searchView, int maxpixels) {
        IMPL.setMaxWidth(searchView, maxpixels);
    }

    public static interface OnCloseListener {
        public boolean onClose();
    }

    @Deprecated
    public static abstract class OnCloseListenerCompat
    implements OnCloseListener {
        @Override
        public boolean onClose() {
            return false;
        }
    }

    public static interface OnQueryTextListener {
        public boolean onQueryTextSubmit(String var1);

        public boolean onQueryTextChange(String var1);
    }

    @Deprecated
    public static abstract class OnQueryTextListenerCompat
    implements OnQueryTextListener {
        @Override
        public boolean onQueryTextSubmit(String query) {
            return false;
        }

        @Override
        public boolean onQueryTextChange(String newText) {
            return false;
        }
    }

    static class SearchViewCompatIcsImpl
    extends SearchViewCompatHoneycombImpl {
        SearchViewCompatIcsImpl() {
        }

        @Override
        public View newSearchView(Context context) {
            return SearchViewCompatIcs.newSearchView((Context)context);
        }

        @Override
        public void setImeOptions(View searchView, int imeOptions) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatIcs.setImeOptions((View)searchView, (int)imeOptions);
        }

        @Override
        public void setInputType(View searchView, int inputType) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatIcs.setInputType((View)searchView, (int)inputType);
        }
    }

    static class SearchViewCompatHoneycombImpl
    extends SearchViewCompatStubImpl {
        SearchViewCompatHoneycombImpl() {
        }

        @Override
        public View newSearchView(Context context) {
            return SearchViewCompatHoneycomb.newSearchView((Context)context);
        }

        @Override
        public void setSearchableInfo(View searchView, ComponentName searchableComponent) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatHoneycomb.setSearchableInfo((View)searchView, (ComponentName)searchableComponent);
        }

        @Override
        public Object newOnQueryTextListener(final OnQueryTextListener listener) {
            return SearchViewCompatHoneycomb.newOnQueryTextListener((SearchViewCompatHoneycomb.OnQueryTextListenerCompatBridge)new SearchViewCompatHoneycomb.OnQueryTextListenerCompatBridge(){

                public boolean onQueryTextSubmit(String query) {
                    return listener.onQueryTextSubmit(query);
                }

                public boolean onQueryTextChange(String newText) {
                    return listener.onQueryTextChange(newText);
                }
            });
        }

        @Override
        public void setOnQueryTextListener(View searchView, OnQueryTextListener listener) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatHoneycomb.setOnQueryTextListener((View)searchView, (Object)this.newOnQueryTextListener(listener));
        }

        @Override
        public Object newOnCloseListener(final OnCloseListener listener) {
            return SearchViewCompatHoneycomb.newOnCloseListener((SearchViewCompatHoneycomb.OnCloseListenerCompatBridge)new SearchViewCompatHoneycomb.OnCloseListenerCompatBridge(){

                public boolean onClose() {
                    return listener.onClose();
                }
            });
        }

        @Override
        public void setOnCloseListener(View searchView, OnCloseListener listener) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatHoneycomb.setOnCloseListener((View)searchView, (Object)this.newOnCloseListener(listener));
        }

        @Override
        public CharSequence getQuery(View searchView) {
            this.checkIfLegalArg(searchView);
            return SearchViewCompatHoneycomb.getQuery((View)searchView);
        }

        @Override
        public void setQuery(View searchView, CharSequence query, boolean submit) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatHoneycomb.setQuery((View)searchView, (CharSequence)query, (boolean)submit);
        }

        @Override
        public void setQueryHint(View searchView, CharSequence hint) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatHoneycomb.setQueryHint((View)searchView, (CharSequence)hint);
        }

        @Override
        public void setIconified(View searchView, boolean iconify) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatHoneycomb.setIconified((View)searchView, (boolean)iconify);
        }

        @Override
        public boolean isIconified(View searchView) {
            this.checkIfLegalArg(searchView);
            return SearchViewCompatHoneycomb.isIconified((View)searchView);
        }

        @Override
        public void setSubmitButtonEnabled(View searchView, boolean enabled) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatHoneycomb.setSubmitButtonEnabled((View)searchView, (boolean)enabled);
        }

        @Override
        public boolean isSubmitButtonEnabled(View searchView) {
            this.checkIfLegalArg(searchView);
            return SearchViewCompatHoneycomb.isSubmitButtonEnabled((View)searchView);
        }

        @Override
        public void setQueryRefinementEnabled(View searchView, boolean enable) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatHoneycomb.setQueryRefinementEnabled((View)searchView, (boolean)enable);
        }

        @Override
        public boolean isQueryRefinementEnabled(View searchView) {
            this.checkIfLegalArg(searchView);
            return SearchViewCompatHoneycomb.isQueryRefinementEnabled((View)searchView);
        }

        @Override
        public void setMaxWidth(View searchView, int maxpixels) {
            this.checkIfLegalArg(searchView);
            SearchViewCompatHoneycomb.setMaxWidth((View)searchView, (int)maxpixels);
        }

        protected void checkIfLegalArg(View searchView) {
            SearchViewCompatHoneycomb.checkIfLegalArg((View)searchView);
        }
    }

    static class SearchViewCompatStubImpl
    implements SearchViewCompatImpl {
        SearchViewCompatStubImpl() {
        }

        @Override
        public View newSearchView(Context context) {
            return null;
        }

        @Override
        public void setSearchableInfo(View searchView, ComponentName searchableComponent) {
        }

        @Override
        public void setImeOptions(View searchView, int imeOptions) {
        }

        @Override
        public void setInputType(View searchView, int inputType) {
        }

        @Override
        public Object newOnQueryTextListener(OnQueryTextListener listener) {
            return null;
        }

        @Override
        public void setOnQueryTextListener(View searchView, OnQueryTextListener listener) {
        }

        @Override
        public Object newOnCloseListener(OnCloseListener listener) {
            return null;
        }

        @Override
        public void setOnCloseListener(View searchView, OnCloseListener listener) {
        }

        @Override
        public CharSequence getQuery(View searchView) {
            return null;
        }

        @Override
        public void setQuery(View searchView, CharSequence query, boolean submit) {
        }

        @Override
        public void setQueryHint(View searchView, CharSequence hint) {
        }

        @Override
        public void setIconified(View searchView, boolean iconify) {
        }

        @Override
        public boolean isIconified(View searchView) {
            return true;
        }

        @Override
        public void setSubmitButtonEnabled(View searchView, boolean enabled) {
        }

        @Override
        public boolean isSubmitButtonEnabled(View searchView) {
            return false;
        }

        @Override
        public void setQueryRefinementEnabled(View searchView, boolean enable) {
        }

        @Override
        public boolean isQueryRefinementEnabled(View searchView) {
            return false;
        }

        @Override
        public void setMaxWidth(View searchView, int maxpixels) {
        }
    }

    static interface SearchViewCompatImpl {
        public View newSearchView(Context var1);

        public void setSearchableInfo(View var1, ComponentName var2);

        public void setImeOptions(View var1, int var2);

        public void setInputType(View var1, int var2);

        public Object newOnQueryTextListener(OnQueryTextListener var1);

        public void setOnQueryTextListener(View var1, OnQueryTextListener var2);

        public Object newOnCloseListener(OnCloseListener var1);

        public void setOnCloseListener(View var1, OnCloseListener var2);

        public CharSequence getQuery(View var1);

        public void setQuery(View var1, CharSequence var2, boolean var3);

        public void setQueryHint(View var1, CharSequence var2);

        public void setIconified(View var1, boolean var2);

        public boolean isIconified(View var1);

        public void setSubmitButtonEnabled(View var1, boolean var2);

        public boolean isSubmitButtonEnabled(View var1);

        public void setQueryRefinementEnabled(View var1, boolean var2);

        public boolean isQueryRefinementEnabled(View var1);

        public void setMaxWidth(View var1, int var2);
    }
}

